/*
 * Decompiled with CFR 0.152.
 */
package com.daydayup.framework.web.wrapper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.daydayup.framework.core.context.Context;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class JsonRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] body;

    public JsonRequestWrapper(HttpServletRequest request) {
        super(request);
        try {
            List list;
            Map map = (Map)Context.getContext().getAttribute("httpJsonRequestParam", Map.class);
            if (map != null) {
                this.body = JSONObject.toJSON((Object)map).toString().getBytes(Charset.forName("UTF-8"));
            }
            if (!CollectionUtils.isEmpty((Collection)(list = (List)Context.getContext().getAttribute("httpJsonRequestListParam", List.class)))) {
                this.body = JSONObject.toJSON((Object)list).toString().getBytes(Charset.forName("UTF-8"));
            }
        }
        catch (Exception e) {
            System.out.println("JsonRequestWrapper" + e.getMessage());
        }
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public String[] getParameterValues(String name) {
        Map jsonParamMap = (Map)Context.getContext().getAttribute("httpJsonRequestParam", Map.class);
        Object value = jsonParamMap.get(name);
        if (value == null) {
            return super.getParameterValues(name);
        }
        if (value instanceof List) {
            List vgs = (List)value;
            String[] arr = this.toArray(StringUtils.join((Iterable)vgs, (String)","));
            return arr;
        }
        if (value instanceof Map) {
            String jsonStr = JSON.toJSONString(value);
            String[] arr = this.toArray(jsonStr);
            return arr;
        }
        String[] ss = this.toArray(value);
        return ss;
    }

    public Map<String, String[]> getParameterMap() {
        Map parameterMap = super.getParameterMap();
        HashMap<String, String[]> newParameterMap = new HashMap<String, String[]>();
        if (parameterMap != null) {
            for (Map.Entry entry : parameterMap.entrySet()) {
                newParameterMap.put((String)entry.getKey(), (String[])entry.getValue());
            }
        }
        Map jsonParamMap = (Map)Context.getContext().getAttribute("httpJsonRequestParam", Map.class);
        for (Map.Entry m : jsonParamMap.entrySet()) {
            newParameterMap.put((String)m.getKey(), this.toArray(m.getValue()));
        }
        return newParameterMap;
    }

    public Enumeration<String> getParameterNames() {
        Enumeration enumeration = super.getParameterNames();
        Vector<String> vector = new Vector<String>();
        Map jsonParamMap = (Map)Context.getContext().getAttribute("httpJsonRequestParam", Map.class);
        for (Map.Entry m : jsonParamMap.entrySet()) {
            vector.add((String)m.getKey());
        }
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            vector.add(name);
        }
        return vector.elements();
    }

    private String[] toArray(String context) {
        if (context == null) {
            return null;
        }
        return new String[]{context};
    }

    private String[] toArray(Object context) {
        if (context == null) {
            return null;
        }
        String vars = context.toString();
        return new String[]{vars};
    }
}

