/*
 * Decompiled with CFR 0.152.
 */
package com.daydayup.framework.web.process;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class WebMvcConfigurer
extends WebMvcConfigurerAdapter {
    @Autowired
    private ObjectMapper objectMapper;

    @Bean
    public WebMvcConfigurer corsConfigurer() {
        return new WebMvcConfigurer(){

            public void addCorsMappings(CorsRegistry registry) {
                registry.addMapping("/**");
            }
        };
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseSuffixPatternMatch(Boolean.valueOf(false));
        configurer.setUseTrailingSlashMatch(Boolean.valueOf(true));
        configurer.setUseRegisteredSuffixPatternMatch(Boolean.valueOf(true));
        AntPathMatcher pathMatcher = new AntPathMatcher();
        pathMatcher.setTrimTokens(true);
        configurer.setPathMatcher((PathMatcher)pathMatcher);
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        super.configureMessageConverters(converters);
        FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.PrettyFormat});
        fastConverter.setFastJsonConfig(fastJsonConfig);
        converters.add((HttpMessageConverter<?>)fastConverter);
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        ArrayList copy = new ArrayList(converters.size());
        Iterator<HttpMessageConverter<?>> iterator = converters.iterator();
        while (iterator.hasNext()) {
            HttpMessageConverter<?> converter = iterator.next();
            if (converter instanceof MappingJackson2HttpMessageConverter) {
                iterator.remove();
                continue;
            }
            copy.add(converter);
        }
        converters.add((HttpMessageConverter<?>)this.createMappingJackson2HttpMessageConverter());
        converters.addAll(copy);
    }

    private MappingJackson2HttpMessageConverter createMappingJackson2HttpMessageConverter() {
        if (this.objectMapper == null) {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
            this.objectMapper = objectMapper;
        }
        return new MappingJackson2HttpMessageConverter(this.objectMapper);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(true).ignoreAcceptHeader(true).parameterName("mediaType").mediaType("html", MediaType.TEXT_HTML).mediaType("jsp", MediaType.TEXT_HTML).mediaType("do", MediaType.APPLICATION_JSON_UTF8).mediaType("json", MediaType.APPLICATION_JSON_UTF8);
    }

    public void addInterceptors(InterceptorRegistry registry) {
    }
}

