/*
 * Decompiled with CFR 0.152.
 */
package com.daydayup.framework.web.assemble;

import com.daydayup.framework.web.enums.ErrorMsgCode;
import com.daydayup.framework.web.enums.ResultCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Generated;

@ApiModel(value="\u63a5\u53e3\u8fd4\u56de\u5bf9\u8c61", description="\u63a5\u53e3\u8fd4\u56de\u5bf9\u8c61")
public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u6210\u529f\u6807\u5fd7")
    public static final String successStr = "OK";
    @ApiModelProperty(value="\u6210\u529f\u6807\u5fd7")
    private boolean success = true;
    @ApiModelProperty(value="\u8fd4\u56de\u5904\u7406\u6d88\u606f")
    private String message = "\u64cd\u4f5c\u6210\u529f\uff01";
    @ApiModelProperty(value="\u8fd4\u56de\u4ee3\u7801")
    private Integer code = 200;
    @ApiModelProperty(value="\u8fd4\u56de\u6570\u636e\u5bf9\u8c61")
    private T result;
    @ApiModelProperty(value="\u65f6\u95f4\u6233")
    private long timestamp = System.currentTimeMillis();

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public Result<T> success(String message) {
        this.message = message;
        this.code = ResultCode.SC_OK_200.getCode();
        this.success = true;
        this.timestamp = System.currentTimeMillis();
        return this;
    }

    public static Result<Object> ok() {
        Result<Object> r = new Result<Object>();
        r.setSuccess(true);
        r.setCode(ResultCode.SC_OK_200.getCode());
        r.setMessage("\u6210\u529f");
        r.setTimestamp(System.currentTimeMillis());
        return r;
    }

    public static <T> Result<T> ok(String msg) {
        Result<T> r = new Result<T>();
        r.setSuccess(true);
        r.setCode(ResultCode.SC_OK_200.getCode());
        r.setMessage(msg);
        r.setTimestamp(System.currentTimeMillis());
        return r;
    }

    public static <T> Result<T> ok(T result) {
        Result<T> r = new Result<T>();
        r.setSuccess(true);
        r.setCode(ResultCode.SC_OK_200.getCode());
        r.setResult(result);
        r.setTimestamp(System.currentTimeMillis());
        return r;
    }

    public static <T> Result<T> result(T result) {
        Result<T> r = new Result<T>();
        r.setSuccess(true);
        r.setCode(ResultCode.SC_OK_200.getCode());
        r.setResult(result);
        r.setTimestamp(System.currentTimeMillis());
        return r;
    }

    public static <T> Result<T> error(T errorData) {
        return Result.error(ResultCode.RULES_FAILED.getCode(), errorData);
    }

    public static <T> Result<T> error(T errorData, String msg) {
        return Result.error(ResultCode.RULES_FAILED.getCode(), errorData, msg);
    }

    public static Result<Object> error(String msg) {
        return Result.error(ResultCode.ERROR_500.getCode(), msg);
    }

    public static Result<Object> error(ErrorMsgCode msgCode) {
        return Result.error(msgCode.getCode(), msgCode.getMsg());
    }

    public static Result<Object> error(ResultCode code) {
        return Result.error(code.getCode(), code.getMsg());
    }

    public static Result<Object> error(int code, String msg) {
        Result<Object> r = new Result<Object>();
        r.setCode(code);
        r.setMessage(msg);
        r.setSuccess(false);
        r.setTimestamp(System.currentTimeMillis());
        return r;
    }

    public static <T> Result<T> error(int code, T errorData, String msg) {
        Result<T> r = new Result<T>();
        r.setCode(code);
        r.setMessage(msg);
        r.setResult(errorData);
        r.setSuccess(false);
        r.setTimestamp(System.currentTimeMillis());
        return r;
    }

    public static <T> Result<T> error(int code, T errorData) {
        Result<T> r = new Result<T>();
        r.setCode(code);
        r.setMessage("");
        r.setResult(errorData);
        r.setSuccess(false);
        r.setTimestamp(System.currentTimeMillis());
        return r;
    }

    public Result<T> error500(String message) {
        this.message = message;
        this.code = ResultCode.ERROR_500.getCode();
        this.success = false;
        this.timestamp = System.currentTimeMillis();
        return this;
    }

    public static Result<Object> noauth(String msg) {
        return Result.error(ResultCode.FORBIDDEN.getCode(), msg);
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Integer getCode() {
        return this.code;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setCode(Integer code) {
        this.code = code;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Result(success=" + this.isSuccess() + ", message=" + this.getMessage() + ", code=" + this.getCode() + ", result=" + this.getResult() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

