/*
 * Decompiled with CFR 0.152.
 */
package com.daydayup.framework.web.filter;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.daydayup.framework.common.util.SystemUtils;
import com.daydayup.framework.core.context.Context;
import com.daydayup.framework.core.context.IContext;
import com.daydayup.framework.web.assemble.Result;
import com.daydayup.framework.web.enums.ResultCode;
import com.daydayup.framework.web.filter.CodeRouteMapping;
import com.daydayup.framework.web.wrapper.JsonRequestWrapper;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuthRequestFilter
implements Filter,
Ordered {
    @Generated
    private static final Logger log = LogManager.getLogger(AuthRequestFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        Boolean islogin;
        String contentType;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        IContext context = Context.getContext();
        if (context == null) {
            Context ct = new Context();
            ct.init(request, response);
            Context.setContext((Context)ct);
        }
        if (StringUtils.indexOfIgnoreCase((CharSequence)(contentType = request.getContentType()), (CharSequence)"application/json") >= 0) {
            if (contentType.contains("application/json")) {
                request = this.jsonToParameter(request);
            }
        } else if (request.getMethod().equals("GET")) {
            request = this.jsonToParameter(request);
        }
        if (!(islogin = this.loginHandle(request)).booleanValue()) {
            Result<Object> result1 = Result.error(ResultCode.LOGIN_FAIL);
            response.setStatus(HttpStatus.OK.value());
            SystemUtils.printJson((HttpServletResponse)response, (String)JSON.toJSONString(result1));
            return;
        }
        try {
            if (request.getRequestURI().equals("/api/router/rest")) {
                String code = request.getHeader("method");
                if (StrUtil.isBlank((CharSequence)code)) {
                    Result<Object> result1 = Result.error("missing 'method' header");
                    response.setStatus(HttpStatus.OK.value());
                    SystemUtils.printJson((HttpServletResponse)response, (String)JSON.toJSONString(result1));
                    return;
                }
                String targetPath = CodeRouteMapping.getTargetPath(code);
                RequestDispatcher dispatcher = request.getRequestDispatcher(targetPath);
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        finally {
            if (context != null) {
                context.invalidate();
            }
            context = null;
        }
    }

    public void getAllParameters(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String paramName = (String)entry.getKey();
            String[] stringArray = (String[])entry.getValue();
        }
    }

    private Boolean loginHandle(HttpServletRequest req) {
        return true;
    }

    public void destroy() {
    }

    public int getOrder() {
        return -90;
    }

    public HttpServletRequest jsonToParameter(HttpServletRequest req) {
        Map getParams;
        String paramJson = "";
        String method = req.getMethod();
        HashMap<String, Object> jsonRequestParam = new HashMap<String, Object>();
        ArrayList array = new ArrayList();
        if ("POST".equalsIgnoreCase(method)) {
            paramJson = this.requestInputStream(req);
            if (StringUtils.isNotBlank((CharSequence)paramJson)) {
                JsonRequestWrapper jRequestWrapper;
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
                try {
                    JsonNode root = objectMapper.readTree(paramJson);
                    if (root instanceof ObjectNode) {
                        Iterator elements = root.fields();
                        while (elements.hasNext()) {
                            IContext context;
                            Map.Entry node = (Map.Entry)elements.next();
                            String key2 = (String)node.getKey();
                            Object val = objectMapper.readValue(((JsonNode)node.getValue()).toString(), Object.class);
                            jsonRequestParam.put(key2, val);
                            if (key2.equals("scopeMenuId")) {
                                context = Context.getContext();
                                context.setAttribute("scopeMenuId", val);
                            }
                            if (key2.equals("commonScope")) {
                                context = Context.getContext();
                                context.setAttribute("commonScope", val);
                            }
                            if (!key2.equals("commonScopeType")) continue;
                            context = Context.getContext();
                            context.setAttribute("commonScopeType", val);
                        }
                    } else if (root instanceof ArrayNode) {
                        for (JsonNode r : root) {
                            Iterator elements = r.fields();
                            HashMap<String, Object> jsonRequestListParam = new HashMap<String, Object>();
                            while (elements.hasNext()) {
                                IContext context;
                                Map.Entry node = (Map.Entry)elements.next();
                                String key3 = (String)node.getKey();
                                Object val = objectMapper.readValue(((JsonNode)node.getValue()).toString(), Object.class);
                                jsonRequestListParam.put(key3, val);
                                if (key3.equals("scopeMenuId")) {
                                    context = Context.getContext();
                                    context.setAttribute("scopeMenuId", val);
                                }
                                if (key3.equals("commonScope")) {
                                    context = Context.getContext();
                                    context.setAttribute("commonScope", (Object)Integer.valueOf(val.toString()));
                                }
                                if (!key3.equals("commonScopeType")) continue;
                                context = Context.getContext();
                                context.setAttribute("commonScopeType", (Object)val.toString());
                            }
                            array.add(jsonRequestListParam);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("jsonToParameter -- error -- ", (Throwable)e);
                }
                if (!CollectionUtils.isEmpty(array)) {
                    Context.getContext().setAttribute("httpJsonRequestListParam", array);
                    jRequestWrapper = new JsonRequestWrapper(req);
                    return jRequestWrapper;
                }
                if (StringUtils.isNotBlank((CharSequence)paramJson)) {
                    Context.getContext().setAttribute("httpJsonRequestParam", jsonRequestParam);
                    jRequestWrapper = new JsonRequestWrapper(req);
                    return jRequestWrapper;
                }
            }
        } else if ("GET".equalsIgnoreCase(method) && !(getParams = req.getParameterMap()).isEmpty()) {
            try {
                HashMap jsonParams = new HashMap();
                if (!getParams.isEmpty()) {
                    getParams.forEach((key, values) -> {
                        IContext context;
                        Object val;
                        if (((String[])values).length == 1) {
                            jsonParams.put(key, values[0]);
                            val = values[0];
                        } else {
                            jsonParams.put(key, values);
                            val = values;
                        }
                        if (key.equals("scopeMenuId")) {
                            context = Context.getContext();
                            context.setAttribute("scopeMenuId", val);
                        }
                        if (key.equals("commonScope")) {
                            context = Context.getContext();
                            context.setAttribute("commonScope", val);
                        }
                        if (key.equals("commonScopeType")) {
                            context = Context.getContext();
                            context.setAttribute("commonScopeType", val);
                        }
                    });
                }
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
                paramJson = objectMapper.writeValueAsString(jsonParams);
                if (StringUtils.isNotBlank((CharSequence)paramJson)) {
                    Context.getContext().setAttribute("httpJsonRequestParam", jsonRequestParam);
                    JsonRequestWrapper jRequestWrapper = new JsonRequestWrapper(req);
                    return jRequestWrapper;
                }
            }
            catch (JsonProcessingException e) {
                paramJson = "";
                log.error("---- JsonProcessingException", (Throwable)e);
            }
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String requestInputStream(HttpServletRequest req) {
        String jsonParam = "";
        ServletInputStream inputStream = null;
        try {
            int contentLength = req.getContentLength();
            if (contentLength > 0) {
                int len;
                byte[] buffer = new byte[contentLength];
                inputStream = req.getInputStream();
                for (int i = 0; i < contentLength && (len = inputStream.read(buffer, i, contentLength)) != -1; i += len) {
                }
                jsonParam = new String(buffer, "utf-8");
            }
        }
        catch (IOException e) {
            log.error("requestInputStream: \u53c2\u6570\u83b7\u53d6\u6210 error:", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("requestInputStream: \u53c2\u6570\u83b7\u53d6\u6210 error:", (Throwable)e);
                }
            }
        }
        return jsonParam;
    }
}

