/*
 * Decompiled with CFR 0.152.
 */
package com.daydayup.framework.web.process;

import com.daydayup.framework.web.message.WebResp;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ApiResultHandler
implements ResponseBodyAdvice<Object> {
    private List<String> modulePackages;
    private static final Class[] annos = new Class[]{RequestMapping.class, GetMapping.class, PostMapping.class, DeleteMapping.class, PutMapping.class};

    public boolean supports(MethodParameter returnType, Class converterType) {
        AnnotatedElement element = returnType.getAnnotatedElement();
        return Arrays.stream(annos).anyMatch(anno -> anno.isAnnotation() && element.isAnnotationPresent((Class<? extends Annotation>)anno));
    }

    public static boolean belongOwn(List<String> modulePackages, String declaringPackageName) {
        for (String modulePackage : modulePackages) {
            if (!declaringPackageName.startsWith(modulePackage)) continue;
            return true;
        }
        return false;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        Object data = ApiResultHandler.wrapIfNeed(body, returnType);
        String selectedConverterTypeClassName = selectedConverterType.getName();
        if (selectedConverterTypeClassName.indexOf("StringHttpMessageConverter") >= 0) {
            if (data instanceof WebResp) {
                ObjectMapper mapper = new ObjectMapper();
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS});
                mapper.enable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
                mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
                try {
                    return mapper.writeValueAsString(data);
                }
                catch (Exception e) {
                    return data;
                }
            }
            return data;
        }
        return data;
    }

    public static Object wrapIfNeed(Object body, MethodParameter returnType) {
        if (body instanceof WebResp) {
            return body;
        }
        if (body != null) {
            return new WebResp<Object>(body);
        }
        if (body == null) {
            return new WebResp<String>("");
        }
        return new WebResp<Object>(ApiResultHandler.getDefaultValue(returnType));
    }

    public static Object getDefaultValue(MethodParameter returnType) {
        Class bodyType = returnType.getParameterType();
        return ApiResultHandler.getDefaultValue(bodyType);
    }

    private static Object getDefaultValue(Class<?> bodyType) {
        Object body = bodyType.isArray() ? Array.newInstance(bodyType.getComponentType(), 0) : (List.class.isAssignableFrom(bodyType) ? Collections.emptyList() : (Set.class.isAssignableFrom(bodyType) ? Collections.emptySet() : (Map.class.isAssignableFrom(bodyType) ? Collections.emptyMap() : (String.class.isAssignableFrom(bodyType) ? "" : bodyType))));
        return body;
    }
}

