/*
 * Decompiled with CFR 0.152.
 */
package com.daydayup.framework.web.interceptor;

import com.daydayup.framework.core.context.Context;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AllRequestInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AllRequestInterceptor.class);
    public static final String URL_REQUEST_TIME_KEY = "URL_REQUEST_TIME_KEY";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String method = request.getMethod();
        System.out.println("method = " + method);
        return !"OPTIONS".equals(method);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        try {
            long endTime = System.currentTimeMillis();
            String requestTime = (String)Context.getContext().getAttribute(URL_REQUEST_TIME_KEY, String.class);
            if (!StringUtils.isNotBlank((CharSequence)requestTime)) {
                // empty if block
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.afterCompletion(request, response, handler, ex);
    }
}

